using System;
using Server;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a spider corpse" )]
	public class EvoSpiderSumHigh : BaseSummonedEvoSpider
	{
      [Constructable]
		public EvoSpiderSumHigh( Xanthos.Evo.EvoSpider master ) : base( master )
		{
			Body = 11;
			BaseSoundID = 1170;
// 			Hue = 271;

			SetStr( 200 );
			SetDex( 100 );
			SetInt( 20 );

			SetHits( 250 );
			SetStam( 100 );
			SetMana( 0 );

			SetDamage( 14, 17 );

			SetDamageType( ResistanceType.Physical, 40 );
			SetDamageType( ResistanceType.Poison, 60 );

			SetResistance( ResistanceType.Physical, 60, 70 );
			SetResistance( ResistanceType.Fire, 50, 60 );
			SetResistance( ResistanceType.Cold, 50, 60 );
			SetResistance( ResistanceType.Poison, 90, 100 );
			SetResistance( ResistanceType.Energy, 50, 60 );

			SetSkill( SkillName.MagicResist, 100.0 );
			SetSkill( SkillName.Tactics, 110.0 );
			SetSkill( SkillName.Wrestling, 110.0 );
			SetSkill( SkillName.Poisoning, 90.0 );

			Fame = 0;
			Karma = 0;

			VirtualArmor = 40;
		}
		
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override Poison HitPoison{ get{ return Poison.Deadly; } }

		public EvoSpiderSumHigh( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}